/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;

public class LavaSwimNodeEvaluator
extends NodeEvaluator {
    private final boolean allowBreaching;
    private final Long2ObjectMap<BlockPathTypes> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    public LavaSwimNodeEvaluator(boolean p_77457_) {
        this.allowBreaching = p_77457_;
    }

    public void m_6028_(PathNavigationRegion p_192959_, Mob p_192960_) {
        super.m_6028_(p_192959_, p_192960_);
        this.pathTypesByPosCache.clear();
    }

    public void m_6802_() {
        super.m_6802_();
        this.pathTypesByPosCache.clear();
    }

    public Node m_7171_() {
        return super.m_5676_(Mth.m_14107_((double)this.f_77313_.m_20191_().f_82288_), Mth.m_14107_((double)(this.f_77313_.m_20191_().f_82289_ + 0.5)), Mth.m_14107_((double)this.f_77313_.m_20191_().f_82290_));
    }

    public Target m_7568_(double p_77459_, double p_77460_, double p_77461_) {
        return new Target(super.m_5676_(Mth.m_14107_((double)p_77459_), Mth.m_14107_((double)p_77460_), Mth.m_14107_((double)p_77461_)));
    }

    public int m_6065_(Node[] p_77483_, Node p_77484_) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(Direction.class);
        for (Direction direction : Direction.values()) {
            Node node = this.m_5676_(p_77484_.f_77271_ + direction.m_122429_(), p_77484_.f_77272_ + direction.m_122430_(), p_77484_.f_77273_ + direction.m_122431_());
            map.put(direction, node);
            if (!this.isNodeValid(node)) continue;
            p_77483_[i++] = node;
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            Direction direction2 = direction1.m_122427_();
            Node node1 = this.m_5676_(p_77484_.f_77271_ + direction1.m_122429_() + direction2.m_122429_(), p_77484_.f_77272_, p_77484_.f_77273_ + direction1.m_122431_() + direction2.m_122431_());
            if (!this.isDiagonalNodeValid(node1, (Node)map.get(direction1), (Node)map.get(direction2))) continue;
            p_77483_[i++] = node1;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node p_192962_) {
        return p_192962_ != null && !p_192962_.f_77279_;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node p_192964_, @Nullable Node p_192965_, @Nullable Node p_192966_) {
        return this.isNodeValid(p_192964_) && p_192965_ != null && p_192965_.f_77281_ >= 0.0f && p_192966_ != null && p_192966_.f_77281_ >= 0.0f;
    }

    @Nullable
    protected Node m_5676_(int pX, int pY, int pZ) {
        float f;
        Node node = null;
        BlockPathTypes blockpathtypes = this.getCachedBlockType(pX, pY, pZ);
        if ((this.allowBreaching && blockpathtypes == BlockPathTypes.BREACH || blockpathtypes == BlockPathTypes.WATER || blockpathtypes == BlockPathTypes.LAVA) && (f = this.f_77313_.m_21439_(blockpathtypes)) >= 0.0f) {
            node = super.m_5676_(pX, pY, pZ);
            node.f_77282_ = blockpathtypes;
            node.f_77281_ = Math.max(node.f_77281_, f);
            if (this.f_77312_.m_6425_(new BlockPos(pX, pY, pZ)).m_76178_()) {
                node.f_77281_ += 8.0f;
            }
        }
        return node;
    }

    protected BlockPathTypes getCachedBlockType(int p_192968_, int p_192969_, int p_192970_) {
        return (BlockPathTypes)this.pathTypesByPosCache.computeIfAbsent(BlockPos.m_121882_((int)p_192968_, (int)p_192969_, (int)p_192970_), p_192957_ -> this.m_8086_((BlockGetter)this.f_77312_, p_192968_, p_192969_, p_192970_));
    }

    public BlockPathTypes m_8086_(BlockGetter pLevel, int pX, int pY, int pZ) {
        return this.m_7209_(pLevel, pX, pY, pZ, this.f_77313_, this.f_77315_, this.f_77316_, this.f_77317_, this.m_77360_(), this.m_77357_());
    }

    public BlockPathTypes m_7209_(BlockGetter pBlockaccess, int pX, int pY, int pZ, Mob pEntityliving, int pXSize, int pYSize, int pZSize, boolean pCanBreakDoors, boolean pCanEnterDoors) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = pX; i < pX + pXSize; ++i) {
            for (int j = pY; j < pY + pYSize; ++j) {
                int k = pZ;
                if (k >= pZ + pZSize) continue;
                FluidState fluidstate = pBlockaccess.m_6425_((BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k));
                BlockState blockstate = pBlockaccess.m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(i, j, k));
                if (fluidstate.m_76178_() && blockstate.m_60647_(pBlockaccess, blockpos$mutableblockpos.m_7495_(), PathComputationType.WATER) && blockstate.m_60795_()) {
                    return BlockPathTypes.BREACH;
                }
                return fluidstate.m_205070_(FluidTags.f_13132_) ? BlockPathTypes.WATER : BlockPathTypes.BLOCKED;
            }
        }
        BlockState blockstate1 = pBlockaccess.m_8055_((BlockPos)blockpos$mutableblockpos);
        FluidState fluidState1 = pBlockaccess.m_6425_((BlockPos)blockpos$mutableblockpos);
        return fluidState1.m_205070_(FluidTags.f_13132_) ? BlockPathTypes.WATER : BlockPathTypes.BLOCKED;
    }
}

